/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9694;
import zabi.minecraft.extraalchemy.config.ModConfig;
import zabi.minecraft.extraalchemy.crafting.CraftingRecipes;
import zabi.minecraft.extraalchemy.items.ModComponents;
import zabi.minecraft.extraalchemy.items.ModItems;
import zabi.minecraft.extraalchemy.items.PotionRingItem;
import zabi.minecraft.extraalchemy.utils.PotionUtilities;

public class PotionRingRecipe
extends class_1852 {
    private int cost;
    private int length;
    private int renew;
    private Optional<Integer> level;
    private Optional<class_1291> effect;
    private Optional<class_1842> potion;

    public PotionRingRecipe(Optional<Integer> level, int cost, int length, int renew, Optional<class_1291> effect, Optional<class_1842> potion) {
        super(class_7710.field_40250);
        this.cost = cost;
        this.length = length;
        this.renew = renew;
        if (effect.isEmpty() && potion.isEmpty()) {
            throw new IllegalArgumentException("Ring recipes must include a potion or a status effect");
        }
        if (effect.isPresent() && level.isEmpty()) {
            throw new IllegalArgumentException("Ring recipes defined by effect must include a potion level");
        }
        if (effect.isPresent() && potion.isPresent()) {
            throw new IllegalArgumentException("Ring recipes can't include both a potion and a status effect");
        }
        if (potion.isPresent() && potion.get().method_8049().size() != 1) {
            throw new IllegalArgumentException("Ring recipes only support potions with exactly 1 effect");
        }
        if (potion.isPresent() && level.isEmpty()) {
            level = Optional.of(((class_1293)potion.get().method_8049().get(0)).method_5578());
        }
        this.level = level;
        this.effect = effect;
        this.potion = potion;
    }

    public boolean matches(class_9694 input, class_1937 world) {
        if (!ModConfig.INSTANCE.enableRings) {
            return false;
        }
        boolean foundEffect = false;
        boolean foundRing = false;
        List inv = input.method_59989();
        for (int i = 0; i < inv.size(); ++i) {
            class_1799 is = input.method_59984(i);
            class_1792 s = is.method_7909();
            if (s.equals(class_1802.field_8574)) {
                if (foundEffect || !this.doesPotionMatch(PotionUtilities.getEffects(is))) {
                    return false;
                }
                foundEffect = true;
                continue;
            }
            if (s.equals((Object)ModItems.EMPTY_RING)) {
                if (foundRing) {
                    return false;
                }
                foundRing = true;
                continue;
            }
            if (s.equals(class_1802.field_8162)) continue;
            return false;
        }
        return foundRing && foundEffect;
    }

    public class_1799 craft(class_9694 input, class_7225.class_7874 lookup) {
        return this.method_8110(lookup);
    }

    public class_1799 method_8110(class_7225.class_7874 registriesLookup) {
        class_1799 result = new class_1799((class_1935)ModItems.POTION_RING);
        result.method_57379(ModComponents.DISABLED, (Object)true);
        result.method_57379(ModComponents.POTION_RING_DATA, (Object)new PotionRingItem.PotionRingData(Optional.of(this.getEffect()), this.level.get(), this.cost, this.length, this.renew));
        return result;
    }

    public boolean method_8113(int width, int height) {
        return width > 1 || height > 1;
    }

    public class_1865<?> method_8119() {
        return CraftingRecipes.RING_CRAFTING_SERIALIZER;
    }

    private boolean doesPotionMatch(List<class_1293> stack) {
        if (stack.size() != 1) {
            return false;
        }
        class_1293 stackInstance = stack.get(0);
        return ((class_1291)stackInstance.method_5579().comp_349()).equals(this.getEffect()) && stackInstance.method_5578() == this.level.get().intValue();
    }

    private class_1291 getEffect() {
        if (this.potion.isPresent()) {
            return (class_1291)((class_1293)this.potion.get().method_8049().get(0)).method_5579().comp_349();
        }
        return this.effect.get();
    }

    public static class Serializer
    implements class_1865<PotionRingRecipe> {
        private final MapCodec<PotionRingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("level").forGetter(a -> a.level), (App)Codec.INT.fieldOf("cost").forGetter(a -> a.cost), (App)Codec.INT.fieldOf("length").forGetter(a -> a.length), (App)Codec.INT.fieldOf("renew").forGetter(a -> a.renew), (App)class_7923.field_41174.method_39673().optionalFieldOf("effect").forGetter(a -> a.effect), (App)class_7923.field_41179.method_39673().optionalFieldOf("potion").forGetter(a -> a.potion)).apply((Applicative)instance, PotionRingRecipe::new));

        public class_9139<class_9129, PotionRingRecipe> method_56104() {
            return new class_9139<class_9129, PotionRingRecipe>(this){

                public PotionRingRecipe decode(class_9129 buf) {
                    int cost = buf.readInt();
                    int length = buf.readInt();
                    int renew = buf.readInt();
                    int level = buf.readInt();
                    String potion_name = buf.method_19772();
                    class_1291 effect = (class_1291)class_7923.field_41174.method_10223(class_2960.method_60654((String)potion_name));
                    return new PotionRingRecipe(Optional.of(level), cost, length, renew, Optional.of(effect), Optional.empty());
                }

                public void encode(class_9129 buf, PotionRingRecipe recipe) {
                    buf.method_53002(recipe.cost);
                    buf.method_53002(recipe.length);
                    buf.method_53002(recipe.renew);
                    buf.method_53002(recipe.level.get().intValue());
                    buf.method_10814(class_7923.field_41174.method_10221((Object)recipe.getEffect()).toString());
                }
            };
        }

        public MapCodec<PotionRingRecipe> method_53736() {
            return this.CODEC;
        }
    }
}

